//OHSAT GAMES TUTORIAL: MEGALAGA 10 BONUS: POWER UP & MORE! 
//There's a reference to Rolling in the OHSAT Tutorial for this lesson.
//It is your duty to make the reference to Weird Al and not Fred Durst or something equally terrible.   

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>
#include <string.h>

#define LEFT_EDGE 0
#define RIGHT_EDGE 320
#define BOTTOM_EDGE 224

#define MAX_ENEMIES 6
#define MAX_FLY_ENEMIES 3
#define MAX_PLAYER_BULLETS 3
#define MAX_ENEMY_BULLETS 5
#define FLY_SPAWN_DELAY 180 // approx 3 seconds @ 60 FPS

#define ANIM_STRAIGHT 0 //ship movement
#define ANIM_MOVE 1 //ship movement

#define ANIM_WALK 0 //nemo walk
#define ANIM_DIE 7 //nemo sprite

#define SFX_LASER 64
#define SFX_EXPLOSION 65

#define POWERUP_DURATION 160

// Globals

//Score variables
int score = 0;
int score2 = 0;
char label_score[6] = "SCORE\0";
char str_score[6] = "0";
char label_score2[9] = "P2 SCORE";
char str_score2[6] = "0";
int sign(int x){
    return (x > 0) - (x <0);
}

bool game_on = FALSE; 
char msg_start[22] = "PRESS START TO BEGIN!\0";
char msg_reset[26] = "PRESS START TO PLAY AGAIN.";

typedef struct {
    int x, y, w, h;
    int velx, vely;
    int health;
    Sprite* sprite;
    char name[8];
} Entity;

int offset = 0;
u16 enemiesLeft = 0;
char hud_string[40];
bool flyEnemiesSpawned = FALSE;
u16 flySpawnTimer = 0;
Entity boss = {0};
int bossHealth = 20;
bool bossActive = FALSE;
bool bossPhaseTwo = FALSE;
bool bossNearDeath = FALSE;
bool bossDying = FALSE;
s16 bossFireCooldown = 0;
int bossDeathAnimStep = 0;
u16 powerupTimer = 0;
u16 maxPlayerBullets = MAX_PLAYER_BULLETS;

Entity player = {0}, player_2 = {0};
Entity enemies_top[MAX_ENEMIES];
Entity enemies_bottom[MAX_FLY_ENEMIES];
Entity bullets_p1[MAX_PLAYER_BULLETS], bullets_p2[MAX_PLAYER_BULLETS];
Entity enemyBulletsTop[MAX_ENEMY_BULLETS], enemyBulletsFly[MAX_ENEMY_BULLETS];
Entity powerup = {0, 0, 8, 8, 0, 0, 0, NULL, "" };
Entity* powerupOwner = NULL;

u16 bulletsOnScreenP1 = 0, bulletsOnScreenP2 = 0;
u16 enemyBulletsOnScreenTop = 0, enemyBulletsOnScreenFly = 0;

u16 enemyFireCooldownTop = 0;
u16 enemyFireCooldownFly = 0;

int collideEntities(Entity* a, Entity* b)
{
    return (a->x < b->x + b->w && a->x + a->w > b->x && a->y < b->y + b->h && a->y + a->h >= b->y);
}

typedef enum
{
    RapidFire
} Powerup;

// Function declarations
void startGame();
void endGame();
void showText();
void killEntity(Entity* e);
void reviveEntity(Entity* e);
void positionPlayers();
void positionEnemies();
void positionBullets();
void positionEnemyBullets(); 
void shootBullet(Entity* shooter, Entity* bulletArray, u16* bulletCount, int velY);
void enemyFire();
void handleCollisions();
void updateScoreDisplay();
void updateScoreDisplay2();
void spawnFlyEnemies();
void spawnBoss();
void positionBoss();
void bossFire();
void handleBossDamage();
void spawnPowerupAt(u16 X, u16 Y);
void positionPowerup();
void activatePowerup(Entity* player);
void deactivatePowerup();
void myJoyHandler(u16 joy, u16 changed, u16 state);

int main() {
    XGM_setPCM(SFX_LASER, sfx_laser, sizeof(sfx_laser));
    XGM_setPCM(SFX_EXPLOSION, sfx_explosion, sizeof(sfx_explosion));
    XGM_startPlay(intro);
    JOY_init();
    JOY_setEventHandler(&myJoyHandler);

    SYS_disableInts();
    showText(msg_start);
    VDP_loadTileSet(background.tileset, 1, DMA);
    PAL_setPalette(PAL1, background.palette->data, DMA);
    PAL_setPalette(PAL2, background.palette->data, DMA);
    VDP_setScrollingMode(HSCROLL_PLANE, VSCROLL_PLANE);
    PAL_setColor(34, RGB24_TO_VDPCOLOR(0x0078f8));
    SYS_enableInts();

    SPR_init();

    // Init players
    player = (Entity){152, 192, 16, 16, 0, 0, 1, SPR_addSprite(&ship, 152, 192, TILE_ATTR(PAL1, 0, FALSE, FALSE)), "P1"};
    player_2 = (Entity){100, 192, 16, 16, 0, 0, 1, SPR_addSprite(&ship1, 100, 192, TILE_ATTR(PAL1, 0, FALSE, FALSE)), "P2"};

    // Fill background with stars
    for (int i = 0; i < 1280; i++) {
        int thex = i % 40;
        int they = i / 40;
        int val = (random() % 10) + 1;
        if (val > 3) val = 1;
        VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, 0, 0, val), thex, they);
    }

    // Initialize top enemies
    enemiesLeft = 0;
    for (int i = 0; i < MAX_ENEMIES; i++) {
        Sprite* spriteTop = SPR_addSprite(&ship, i * 48, 32, TILE_ATTR(PAL2, 0, TRUE, FALSE));
        if (spriteTop) {
            enemies_top[i] = (Entity){i * 48, 32, 16, 16, 1, 0, 1, spriteTop, ""};
            sprintf(enemies_top[i].name, "E1_%d", i);
            enemiesLeft++;
        } else {
            enemies_top[i].health = 0;
            enemies_top[i].sprite = NULL;
            VDP_drawText("Top sprite failed", 2, 12 + i);
        }
    }

    // Initialize fly enemies inactive (no sprite yet)
    for (int i = 0; i < MAX_FLY_ENEMIES; i++) {
        enemies_bottom[i].health = 0;
        enemies_bottom[i].sprite = NULL;
    }

    // Initialize bullets (off-screen, hidden)
    for (int i = 0; i < MAX_PLAYER_BULLETS; i++) {
        bullets_p1[i] = (Entity){0, -10, 8, 8, 0, 0, 0, SPR_addSprite(&bullet, 0, -10, TILE_ATTR(PAL1, 0, FALSE, FALSE)), ""};
        bullets_p2[i] = (Entity){0, -10, 8, 8, 0, 0, 0, SPR_addSprite(&bullet1, 0, -10, TILE_ATTR(PAL1, 0, FALSE, FALSE)), ""};
        killEntity(&bullets_p1[i]);
        killEntity(&bullets_p2[i]);
    }

    // Initialize enemy bullets (top enemies, bullet sprite)
    for (int i = 0; i < MAX_ENEMY_BULLETS; i++) {
        enemyBulletsTop[i] = (Entity){0, 0, 8, 8, 0, 0, 0, SPR_addSprite(&bullet, 0, -10, TILE_ATTR(PAL2, 0, FALSE, FALSE)), ""};
        killEntity(&enemyBulletsTop[i]);
    }

    // Initialize enemy bullets (fly enemies, bullet1 sprite)
    for (int i = 0; i < MAX_ENEMY_BULLETS; i++) {
        enemyBulletsFly[i] = (Entity){0, 0, 8, 8, 0, 0, 0, SPR_addSprite(&bullet1, 0, -10, TILE_ATTR(PAL2, 0, FALSE, FALSE)), ""};
        killEntity(&enemyBulletsFly[i]);
    }

    //Initialize powerup sprite

    powerup.sprite = SPR_addSprite(&spr_powerup, powerup.x, powerup.y, TILE_ATTR(PAL1, 0, FALSE, FALSE));
    killEntity(&powerup);

    updateScoreDisplay();
    updateScoreDisplay2();

    while (1) {

        if(game_on == TRUE){
        VDP_setVerticalScroll(BG_B, offset -= 2);
        if (offset <= -256) offset = 0;

        positionPlayers();
        positionEnemies();
        positionBullets();
        positionEnemyBullets();
        positionPowerup();
        enemyFire();
        handleCollisions();

        if(powerupTimer > 0){
            powerupTimer--;
            if(powerupTimer == 0){
                deactivatePowerup();
            }
        }

        if (bossActive) {
            positionBoss();
        }
    }
        SPR_update();
        SYS_doVBlankProcess();
    }

    return 0;
}

//Start Game
void startGame(){
    score = 0;
    score2 = 0;

    player.health = 1;
    player_2.health = 1;
    reviveEntity(&player);
    reviveEntity(&player_2);
    player.x = 152;
    player_2.x = 100;

    SPR_setPosition(player.sprite, player.x, player.y);
    SPR_setPosition(player_2.sprite, player_2.x, player_2.y);

    updateScoreDisplay();
    updateScoreDisplay2();

    VDP_clearTextArea(0, 10, 40, 10);
    game_on = TRUE;
}

//End Game
void endGame(){
    //write end game condition
    char final_msg[40];

    if (player.health <= 0 && player_2.health <= 0){
        sprintf(final_msg, "GAME OVER, MAN!");
    }

    if(bossActive && boss.y >BOTTOM_EDGE){
        sprintf(final_msg, "MISSION ACCOMPLISHED!! 2003"); 
    }

    VDP_clearTextArea(0, 10, 40, 4); //Clear space first
    showText(final_msg);            //show final result
    VDP_drawText(msg_reset, 20 -strlen(msg_reset)/2, 17); //restart prompt

    game_on = FALSE;
}

//display centered text
void showText(char s[]){
    VDP_drawText(s, 20 -strlen(s)/2, 15);
}

// Input Handler
void myJoyHandler(u16 joy, u16 changed, u16 state) {
    Entity* p = (joy == JOY_1) ? &player : &player_2;
    Entity* bullets = (joy == JOY_1) ? bullets_p1 : bullets_p2;
    u16* bulletCount = (joy == JOY_1) ? &bulletsOnScreenP1 : &bulletsOnScreenP2;

    if (state & BUTTON_RIGHT) {
        p->velx = 2;
        SPR_setAnim(p->sprite, ANIM_MOVE);
        SPR_setHFlip(p->sprite, TRUE);
    } else if (state & BUTTON_LEFT) {
        p->velx = -2;
        SPR_setAnim(p->sprite, ANIM_MOVE);
        SPR_setHFlip(p->sprite, FALSE);
    } else if ((changed & (BUTTON_LEFT | BUTTON_RIGHT))) {
        p->velx = 0;
        SPR_setAnim(p->sprite, ANIM_STRAIGHT);
    }

//Pressing Start to begin game

    if(state & BUTTON_START){
            if(!game_on){
                startGame();
            }
        }
	

    if ((state & BUTTON_B) && (changed & BUTTON_B)) {
        shootBullet(p, bullets, bulletCount, -3);
    }
}

// Movement and position updates
void positionPlayers() {
    Entity* players[2] = {&player, &player_2};
    for (int i = 0; i < 2; i++) {
        Entity* p = players[i];
        p->x += p->velx;

        if (p->x < LEFT_EDGE) p->x = LEFT_EDGE;
        if (p->x + p->w > RIGHT_EDGE) p->x = RIGHT_EDGE - p->w;

        SPR_setPosition(p->sprite, p->x, p->y);
    }
}

void positionEnemies() {
    // Top enemies
    for (int i = 0; i < MAX_ENEMIES; i++) {
        Entity* e = &enemies_top[i];
        if (e->health > 0) {
            e->x += e->velx;
            if (e->x < LEFT_EDGE || (e->x + e->w) > RIGHT_EDGE) e->velx = -e->velx;
            SPR_setPosition(e->sprite, e->x, e->y);
        }
    }
    // Flying enemies
    for (int i = 0; i < MAX_FLY_ENEMIES; i++) {
        Entity* f = &enemies_bottom[i];
        if (f->health > 0) {
            f->x += f->velx;

            if (f->x < LEFT_EDGE) {
                f->x = LEFT_EDGE;
                f->velx = -f->velx;
            } else if (f->x + f->w > RIGHT_EDGE) {
                f->x = RIGHT_EDGE - f->w;
                f->velx = -f->velx;
            }
            SPR_setPosition(f->sprite, f->x, f->y);
        }
    }
}

void shootBullet(Entity* shooter, Entity* bulletArray, u16* bulletCount, int velY) {
    // Use bonus bullets if shooter has powerup
    u16 bulletLimit = (shooter == powerupOwner) ? maxPlayerBullets : MAX_PLAYER_BULLETS;

    if (*bulletCount < bulletLimit) {
        for (int i = 0; i < MAX_PLAYER_BULLETS; i++) {
            Entity* b = &bulletArray[i];
            if (b->health == 0) {
                b->x = shooter->x + (shooter->w / 2) - (b->w / 2);
                b->y = shooter->y + (velY < 0 ? -b->h : shooter->h);
                b->vely = velY;
                reviveEntity(b);
                SPR_setPosition(b->sprite, b->x, b->y);
                XGM_startPlayPCM(SFX_LASER, 1, SOUND_PCM_CH2);
                (*bulletCount)++;
                break;
            }
        }
    }
}

void positionBullets() {
    for (int i = 0; i < MAX_PLAYER_BULLETS; i++) {
        // Player 1 bullets
        Entity* b1 = &bullets_p1[i];
        if (b1->health > 0) {
            b1->y += b1->vely;
            if (b1->y + b1->h < 0) {
                killEntity(b1);
                if (bulletsOnScreenP1 > 0) bulletsOnScreenP1--;
            } else {
                SPR_setPosition(b1->sprite, b1->x, b1->y);
            }
        }

        // Player 2 bullets
        Entity* b2 = &bullets_p2[i];
        if (b2->health > 0) {
            b2->y += b2->vely;
            if (b2->y + b2->h < 0) {
                killEntity(b2);
                if (bulletsOnScreenP2 > 0) bulletsOnScreenP2--;
            } else {
                SPR_setPosition(b2->sprite, b2->x, b2->y);
            }
        }
    }
}

void positionEnemyBullets() {
    // Enemy bullets from top enemies (including boss)
    for (int i = 0; i < MAX_ENEMY_BULLETS; i++) {
        Entity* eb = &enemyBulletsTop[i];
        if (eb->health > 0) {
            eb->x += eb->velx;  // <-- newly added
            eb->y += eb->vely;
            if (eb->y > BOTTOM_EDGE) {
                killEntity(eb);
                if (enemyBulletsOnScreenTop > 0) enemyBulletsOnScreenTop--;
            } else {
                SPR_setVFlip(eb->sprite, TRUE); // Ensure vertical flip
                SPR_setPosition(eb->sprite, eb->x, eb->y);
            }
        }
    }

    // Enemy bullets from fly enemies
    for (int i = 0; i < MAX_ENEMY_BULLETS; i++) {
        Entity* eb = &enemyBulletsFly[i];
        if (eb->health > 0) {
            eb->y += eb->vely;
            if (eb->y > BOTTOM_EDGE) {
                killEntity(eb);
                if (enemyBulletsOnScreenFly > 0) enemyBulletsOnScreenFly--;
            } else {
                SPR_setVFlip(eb->sprite, TRUE); // Ensure vertical 
                eb->x += eb->velx;
                SPR_setPosition(eb->sprite, eb->x, eb->y);
            }
        }
    }
}

void enemyFire() {
    // Cooldown timers decrement
    if (enemyFireCooldownTop > 0) enemyFireCooldownTop--;
    if (enemyFireCooldownFly > 0) enemyFireCooldownFly--;

    // Fire from top enemies
    if (enemyFireCooldownTop == 0 && enemiesLeft > 0) {
        for (int i = 0; i < MAX_ENEMIES; i++) {
            Entity* e = &enemies_top[i];
            if (e->health > 0 && enemyBulletsOnScreenTop < MAX_ENEMY_BULLETS) {
                if (random() % 20 == 0) { // 1/20 chance to fire
                    for (int j = 0; j < MAX_ENEMY_BULLETS; j++) {
                        Entity* b = &enemyBulletsTop[j];
                        if (b->health == 0) {
                            b->x = e->x + (e->w / 2) - (b->w / 2);
                            b->y = e->y + e->h;
                            b->vely = 2;
                            reviveEntity(b);
                            enemyBulletsOnScreenTop++;
                            enemyFireCooldownTop = 30;
                            break;
                        }
                    }
                    break;
                }
            }
        }
    }

    // Spawn fly enemies after top enemies all die
    if (enemiesLeft == 0) {
        flySpawnTimer++;
        if (!flyEnemiesSpawned && flySpawnTimer > FLY_SPAWN_DELAY) {
            spawnFlyEnemies();
            flyEnemiesSpawned = TRUE;
        }
    }

    // Fire from fly enemies
    if (flyEnemiesSpawned && enemyFireCooldownFly == 0) {
        for (int i = 0; i < MAX_FLY_ENEMIES; i++) {
            Entity* f = &enemies_bottom[i];
            if (f->health > 0 && enemyBulletsOnScreenFly < MAX_ENEMY_BULLETS) {
                if (random() % 20 == 0) {
                    for (int j = 0; j < MAX_ENEMY_BULLETS; j++) {
                        Entity* b = &enemyBulletsFly[j];
                        if (b->health == 0) {
                            b->x = f->x + (f->w / 2) - (b->w / 2);
                            b->y = f->y + f->h;
                            b->vely = 2;
                            reviveEntity(b);
                            enemyBulletsOnScreenFly++;
                            enemyFireCooldownFly = 30;
                            break;
                        }
                    }
                    break;
                }
            }
        }
    }

    // Boss appears after all fly enemies are defeated
    if (flyEnemiesSpawned) {
        bool allDead = TRUE;
        for (int i = 0; i < MAX_FLY_ENEMIES; i++) {
            if (enemies_bottom[i].health > 0) {
                allDead = FALSE;
                break;
            }
        }
        if (allDead && !bossActive) {
            spawnBoss();
            bossActive = TRUE;
        }
    }

    // Boss fire logic
    if (bossActive && !bossDying) {
        if (bossFireCooldown <= 0) {
            // In phase 2, fire more shots per cooldown (burst)
            int shotsToFire = bossPhaseTwo ? 3 : 1;  // 3 shots per fire in phase 2, else 1 shot
            
            for (int i = 0; i < shotsToFire; i++) {
                bossFire();
                // Optional: add small delay or variation between shots if your engine supports it
            }
            
            // Set a shorter cooldown in phase 2 for faster firing rate
            bossFireCooldown = bossPhaseTwo ? 15 : 30;  
        } else {
            bossFireCooldown--;
            if (bossFireCooldown < 0) bossFireCooldown = 0;
        }
    }
}

void handleCollisions() {
    // Player bullets vs top enemies
    for (int i = 0; i < MAX_PLAYER_BULLETS; i++) {
        Entity* b1 = &bullets_p1[i];
        if (b1->health > 0) {
            for (int j = 0; j < MAX_ENEMIES; j++) {
                Entity* e = &enemies_top[j];
                if (e->health > 0) {
                    if (b1->x < e->x + e->w && b1->x + b1->w > e->x &&
                        b1->y < e->y + e->h && b1->y + b1->h > e->y) {
                        killEntity(b1);
                        bulletsOnScreenP1--;
                        e->health--;
                        if (e->health <= 0) {
                            killEntity(e);
                            XGM_startPlayPCM(SFX_EXPLOSION, 1, SOUND_PCM_CH2);
                            enemiesLeft--;
                            score += 10;
                            updateScoreDisplay();
                        }

                           if ((random() % 30) == 0) {
                            spawnPowerupAt(e->x, e->y);
                        }
                    
                        break;
                    }
                }
            }
        }
        Entity* b2 = &bullets_p2[i];
        if (b2->health > 0) {
            for (int j = 0; j < MAX_ENEMIES; j++) {
                Entity* e = &enemies_top[j];
                if (e->health > 0) {
                    if (b2->x < e->x + e->w && b2->x + b2->w > e->x &&
                        b2->y < e->y + e->h && b2->y + b2->h > e->y) {
                        killEntity(b2);
                        bulletsOnScreenP2--;
                        e->health--;
                        if (e->health <= 0) {
                            killEntity(e);
                            XGM_startPlayPCM(SFX_EXPLOSION, 1, SOUND_PCM_CH2);
                            enemiesLeft--;
                            score2 += 10;
                            updateScoreDisplay2();
                               if ((random() % 30) == 0) {
                                spawnPowerupAt(e->x, e->y);
                            }

                        }
                        break;
                    }
                }
            }
        }
    }

    // Player bullets vs fly enemies
    if (flyEnemiesSpawned) {
        for (int i = 0; i < MAX_PLAYER_BULLETS; i++) {
            Entity* b1 = &bullets_p1[i];
            if (b1->health > 0) {
                for (int j = 0; j < MAX_FLY_ENEMIES; j++) {
                    Entity* f = &enemies_bottom[j];
                    if (f->health > 0) {
                        if (b1->x < f->x + f->w && b1->x + b1->w > f->x &&
                            b1->y < f->y + f->h && b1->y + b1->h > f->y) {
                            killEntity(b1);
                            bulletsOnScreenP1--;
                            f->health--;
                            if (f->health <= 0) {
                                killEntity(f);
                                XGM_startPlayPCM(SFX_EXPLOSION, 1, SOUND_PCM_CH2);
                                score += 15;
                                updateScoreDisplay();

                                   if ((random() % 30) == 0) {
                                    spawnPowerupAt(f->x, f->y);
                                }

                            }
                            break;
                        }
                    }
                }
            }
            Entity* b2 = &bullets_p2[i];
            if (b2->health > 0) {
                for (int j = 0; j < MAX_FLY_ENEMIES; j++) {
                    Entity* f = &enemies_bottom[j];
                    if (f->health > 0) {
                        if (b2->x < f->x + f->w && b2->x + b2->w > f->x &&
                            b2->y < f->y + f->h && b2->y + b2->h > f->y) {
                            killEntity(b2);
                            bulletsOnScreenP2--;
                            f->health--;
                            if (f->health <= 0) {
                                killEntity(f);
                                XGM_startPlayPCM(SFX_EXPLOSION, 1, SOUND_PCM_CH2);
                                score2 += 15;
                                updateScoreDisplay2();

                                   if ((random() % 30) == 0) {
                                    spawnPowerupAt(f->x, f->y);
                                }

                            }
                            break;
                        }
                    }
                }
            }
        }
    }

    // Enemy bullets vs players
    for (int i = 0; i < MAX_ENEMY_BULLETS; i++) {
        Entity* ebTop = &enemyBulletsTop[i];
        if (ebTop->health > 0) {
            if (ebTop->x < player.x + player.w && ebTop->x + ebTop->w > player.x &&
                ebTop->y < player.y + player.h && ebTop->y + ebTop->h > player.y) {
                killEntity(ebTop);
                enemyBulletsOnScreenTop--;
                
            }
            if (ebTop->x < player_2.x + player_2.w && ebTop->x + ebTop->w > player_2.x &&
                ebTop->y < player_2.y + player_2.h && ebTop->y + ebTop->h > player_2.y) {
                killEntity(ebTop);
                enemyBulletsOnScreenTop--;
                
            }
        }
        Entity* ebFly = &enemyBulletsFly[i];
        if (ebFly->health > 0) {
            if (ebFly->x < player.x + player.w && ebFly->x + ebFly->w > player.x &&
                ebFly->y < player.y + player.h && ebFly->y + ebFly->h > player.y) {
                killEntity(ebFly);
                enemyBulletsOnScreenFly--;
                
            }
            if (ebFly->x < player_2.x + player_2.w && ebFly->x + ebFly->w > player_2.x &&
                ebFly->y < player_2.y + player_2.h && ebFly->y + ebFly->h > player_2.y) {
                killEntity(ebFly);
                enemyBulletsOnScreenFly--;
                
        }
    }
    //boss collision
        if (bossActive && !bossDying) {
        for (int i = 0; i < MAX_PLAYER_BULLETS; i++) {
            Entity* b1 = &bullets_p1[i];
            Entity* b2 = &bullets_p2[i];

            Entity* bullets[] = {b1, b2};

            for (int b = 0; b < 2; b++) {
                Entity* bullet = bullets[b];
                if (bullet->health > 0 &&
                    bullet->x < boss.x + boss.w && bullet->x + bullet->w > boss.x &&
                    bullet->y < boss.y + boss.h && bullet->y + bullet->h > boss.y) {
                    killEntity(bullet);
                    if (b == 0) bulletsOnScreenP1--;
                    else bulletsOnScreenP2--;
                    bossHealth--;

                    if (bossHealth == 10) {
                        bossPhaseTwo = TRUE;
                        boss.velx *= 2;
                    } else if (bossHealth == 5) {
                        bossNearDeath = TRUE;
                    } else if (bossHealth <= 0) {
                        bossDying = TRUE;
                        boss.velx = 0;
                        boss.y -= 10; // upward nudge
                    }
                    break;
                }
            }
        }
    }

// Top enemy bullets vs players
    for (int i = 0; i < MAX_ENEMY_BULLETS; i++) {
        Entity* eb = &enemyBulletsTop[i];
        if (eb->health > 0) {
            if (player.health > 0 &&
                eb->x < player.x + player.w && eb->x + eb->w > player.x &&
                eb->y < player.y + player.h && eb->y + eb->h > player.y) {
                killEntity(eb);
                killEntity(&player);
                enemyBulletsOnScreenTop--;
            } else if (player_2.health > 0 &&
                eb->x < player_2.x + player_2.w && eb->x + eb->w > player_2.x &&
                eb->y < player_2.y + player_2.h && eb->y + eb->h > player_2.y) {
                killEntity(eb);
                killEntity(&player_2);
                enemyBulletsOnScreenTop--;
            }
        }
    }

// Fly enemy bullets vs players
    for (int i = 0; i < MAX_ENEMY_BULLETS; i++) {
        Entity* eb = &enemyBulletsFly[i];
        if (eb->health > 0) {
            if (player.health > 0 &&
                eb->x < player.x + player.w && eb->x + eb->w > player.x &&
                eb->y < player.y + player.h && eb->y + eb->h > player.y) {
                killEntity(eb);
                killEntity(&player);
                enemyBulletsOnScreenFly--;
            } else if (player_2.health > 0 &&
                eb->x < player_2.x + player_2.w && eb->x + eb->w > player_2.x &&
                eb->y < player_2.y + player_2.h && eb->y + eb->h > player_2.y) {
                killEntity(eb);
                killEntity(&player_2);
                enemyBulletsOnScreenFly--;
            }
        }
    }

//Check for game over
    if(player.health <= 0 && player_2.health <= 0){
        endGame();
    }
    }
}

void killEntity(Entity* e) {
    e->health = 0;
    SPR_setVisibility(e->sprite, HIDDEN);
}

void reviveEntity(Entity* e) {
    e->health = 1;
    SPR_setVisibility(e->sprite, VISIBLE);
}

void updateScoreDisplay() {
    sprintf(str_score, "%04d", score); // convert Player 1 score to string
    VDP_clearText(0, 0, 6);            // clear old score
    VDP_drawText("P1:", 0, 0);         // label for Player 1
    VDP_drawText(str_score, 4, 0);     // draw Player 1 score
}

void updateScoreDisplay2() {
    sprintf(str_score2, "%04d", score2); // convert Player 2 score to string
    VDP_clearText(30, 0, 6);             // clear old score (right side of screen)
    VDP_drawText("P2:", 30, 0);          // label for Player 2
    VDP_drawText(str_score2, 34, 0);     // draw Player 2 score
}

void spawnFlyEnemies() {
    // Example positions (randomized or fixed, but different)
    int spawnX[MAX_FLY_ENEMIES] = {40, 120, 200};
    int spawnY[MAX_FLY_ENEMIES] = {40, 60, 80};

    for (int i = 0; i < MAX_FLY_ENEMIES; i++) {
        if (enemies_bottom[i].sprite == NULL) {
            enemies_bottom[i].sprite = SPR_addSprite(&efly, spawnX[i], spawnY[i], TILE_ATTR(PAL2, 0, TRUE, FALSE));
        }
        enemies_bottom[i].x = spawnX[i];
        enemies_bottom[i].y = spawnY[i];
        enemies_bottom[i].w = 16;
        enemies_bottom[i].h = 16;

        // Start moving right initially, velocity can be positive or negative
        enemies_bottom[i].velx = (i % 2 == 0) ? 1 : -1;
        enemies_bottom[i].vely = 0;

        enemies_bottom[i].health = 1;
        SPR_setAnim(enemies_bottom[i].sprite, 0);
        SPR_setVisibility(enemies_bottom[i].sprite, VISIBLE);
        SPR_setPosition(enemies_bottom[i].sprite, enemies_bottom[i].x, enemies_bottom[i].y);
    }
}

void spawnBoss() {
    boss.x = 128;
    boss.y = 40;
    boss.w = 32;
    boss.h = 32;
    boss.velx = 1;
    boss.vely = 0;
    boss.health = bossHealth;
    boss.sprite = SPR_addSprite(&nemo_sprite, boss.x, boss.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
    SPR_setAnim(boss.sprite, 0);
    SPR_setVisibility(boss.sprite, VISIBLE);
}

void positionBoss() {
    if (!bossDying) {
        // Normal left-right movement
        boss.x += boss.velx;
        // If boss hits RIGHT_EDGE, flip direction and sprite
        if (boss.x + boss.w > RIGHT_EDGE) {
            boss.x = RIGHT_EDGE - boss.w;  // prevent overflow
            boss.velx = -boss.velx;        // change direction
            SPR_setHFlip(boss.sprite, TRUE);  // face left
        }

        // If boss hits LEFT_EDGE, flip direction and sprite
        else if (boss.x < LEFT_EDGE) {
            boss.x = LEFT_EDGE;           // prevent overflow
            boss.velx = -boss.velx;       // change direction
            SPR_setHFlip(boss.sprite, FALSE); // face right
        }
        SPR_setPosition(boss.sprite, boss.x, boss.y);
    } else {
        // Boss dying animation sequence
        if (bossDeathAnimStep < 32) {  
            // Move boss upward slowly until 32 pixels
            boss.y -= 2;  // move 2 pixels per frame upward
            bossDeathAnimStep += 2;
        } else {
            // Then fall down off the screen
            boss.y += 4; // fall speed, can tweak
            if (boss.y > BOTTOM_EDGE) {
                // Once off screen, hide boss and deactivate
                killEntity(&boss);
                bossActive = FALSE;
                bossDying = FALSE;
                bossDeathAnimStep = 0;
            }
        }
        SPR_setPosition(boss.sprite, boss.x, boss.y);
        SPR_setAnim(boss.sprite, 7);
    }
}

void bossFire() {
    for (int i = 0; i < 3; i++) {
        Entity* b = NULL;
        for (int j = 0; j < MAX_ENEMY_BULLETS; j++) {
            if (enemyBulletsTop[j].health == 0) {
                b = &enemyBulletsTop[j];
                break;
            }
        }
        if (b == NULL) continue;

        b->x = boss.x + (boss.w / 2) - 4;
        b->y = boss.y + boss.h;
        b->vely = 2;

        // Spread bullets by setting horizontal velocity
        if (i == 0) b->velx = -1;
        else if (i == 2) b->velx = 1;
        else b->velx = 0;

        b->sprite = SPR_addSprite(bossPhaseTwo ? &bullet1 : &bullet, b->x, b->y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
        reviveEntity(b);
        enemyBulletsOnScreenTop++;
    }
}

void activatePowerup(Entity* playerEntity) {
    powerupOwner = playerEntity;
    maxPlayerBullets = MAX_PLAYER_BULLETS + 2;
    powerupTimer = POWERUP_DURATION;

    PAL_setColor(18, RGB24_TO_VDPCOLOR(0xf8fc00));
}

void deactivatePowerup() {
    powerupOwner = NULL;
    maxPlayerBullets = MAX_PLAYER_BULLETS;
    PAL_setColor(18, RGB24_TO_VDPCOLOR(0xf83800));
}

void spawnPowerupAt(u16 X, u16 Y){
    powerup.x = X;
    powerup.y = Y;
    reviveEntity(&powerup);
}

void positionPowerup(){
    if(powerup.health > 0){
        powerup.y++;

        if(powerup.y > BOTTOM_EDGE){
            killEntity(&powerup);
            return;
        }

        // Check collision with Player 1
        if (collideEntities(&player, &powerup)) {
            activatePowerup(&player);
            killEntity(&powerup);
            return;
        }

        // Check collision with Player 2
        if (collideEntities(&player_2, &powerup)) {
            activatePowerup(&player_2);
            killEntity(&powerup);
            return;
        }

        SPR_setPosition(powerup.sprite, powerup.x, powerup.y);
    }
}



/////////////////CHANGE LOG//////////////////

/*

Added collision to player 1 and player 2 ships
Added startGame and endGame states
Added <string.h> header for the purpose of the
showText() to show centered text

*/

////////////////////NOTES////////////////////

/*

Code Summary: 




*/

/////////EXPERIMENTATION IDEAS///////////////

/*

I've included new sprites for the fly in the Sprites folder. 
I'm curious to see if I can code some type of mechanic where the fly gets hit and changes to a different
sprite with different mechanics or use it as an indicator for sprite health. 

*/

///////////ERROR HANDLING////////////////////

/*

The game is compiling fine. I fixed a lingering issue with the powerup array which needed the following: 

Entity powerup = {0, 0, 8, 8, 0, 0, 0, NULL, ""};

The bullet collision is somewhat working but the endGame() and startGame() states need fixing. 
It occasionally crashes when you kill the Nemo boss and it's supposed to trigger the alternate final_msg text. 

It's also killing and bringing up the GAME OVER MAN screen during the boss fight. This is likely due to a reset
on the bulletsOnScreen, enemyBulletsOnScreenTop, enemyBulletsOnScreenFly, powerupTimer, powerupOwner, score,
enemiesLeft, & boss[] states. 

I need to find a way to update the endGame() function to do a start of the wave. 

I need to fix the powerup detection. It's currently tied to the player's bullet that killed the ship. I'm fine with
another player ship applying the powerup to the other ship but I probably need to change the color of the powerup
depending on which bullet it detects killing the ship. 

*/